----------------
title : C++ 레퍼런스 - string 의 substr 함수
cat_title :  substr
ref_title : substr, basic_string::substr
path : /C++ Reference/string
publish_date : 2020-07-17
----------------

##@ cpp-ref-start

#@ substr


```cpp-formatted
basic_string substr(size_type pos = 0, size_type count = npos) const;
```

문자열의 일부를 리턴한다.

문자열의 `pos` 번째 문자 부터 `count` 길이 만큼의 문자열을 리턴한다. 만약에, 인자로 전달된 부분 문자열의 길이가 문자열 보다 길다면, 그 이상을 반환하지 않고 문자열의 끝 까지만 리턴한다.

또한, `count` 로 `npos` 를 전달한다면, 자동으로 `pos` 부터 원래 문자열의 끝 까지 리턴한다.

### 인자

* `pos`	: 첫번째 문자의 위치 (원래 문자열에서)
* `count` : 부분 문자열의 길이

### 리턴값

원래 문자열에서 `[pos, pos + count)` 까지의 문자열을 반환한다.

### 예외

만일 `pos` 가 원래 문자열의 길이보다 길다면 `std::out_of_range` 예외를 발생시킨다.

### 시간 복잡도

요청한 부분 문자열의 길이 (`count`) 에 비례한다.

### 예시

```cpp-formatted
#include <iostream>
#include <string>

int main() {
  std::string a = "0123456789abcdefghij";

  // count 가 npos 이므로 pos 부터 문자열 끝까지 리턴한다.
  std::string sub1 = a.substr(10);
  std::cout << sub1 << '\n';

  // pos 와 pos + count 모두 문자열 범위 안이므로, 해당하는 부분 문자열을
  // 리턴한다.
  std::string sub2 = a.substr(5, 3);
  std::cout << sub2 << '\n';

  // pos 는 문자열 범위 안이지만, pos+count 는 밖이므로, pos 부터 문자열 끝까지
  // 리턴한다.
  std::string sub4 = a.substr(a.size() - 3, 50);
  std::cout << sub4 << '\n';

  try {
    // pos 가 문자열 범위 밖이므로 예외를 발생시킴.
    std::string sub5 = a.substr(a.size() + 3, 50);
    std::cout << sub5 << '\n';
  } catch (const std::out_of_range& e) {
    std::cout << "pos exceeds string size\n";
  }
}
```

실행 결과

```exec
abcdefghij
567
hij
pos exceeds string size
```

### 참고 자료

* `copy` : 문자를 복사한다.
* `size` : 문자열의 길이를 리턴한다.
* `find` : 문자열에서 원하는 문자열을 찾는다.